[TestFixture]
public class DbProductGatewayTest : AbstractDbGatewayTest
{
  private DbProductGateway gateway;
  [SetUp]
  public void SetUp()
  {
    OpenConnection();
    gateway = new DbProductGateway(connection);
    ExecuteSql("delete from Products");
  }

  [TearDown]
  public void TearDown()
  {
    Close();
  }

  [Test]
  public void Insert()
  {
    Product product = new Product("Maso orzechowe", "mo", 3);
    gateway.Insert(product);

    SqlCommand command = new SqlCommand("select * from Products", connection);
    reader = command.ExecuteReader();

    Assert.IsTrue(reader.Read());
    Assert.AreEqual("mo", reader["sku"]);
    Assert.AreEqual("Maso orzechowe", reader["name"]);
    Assert.AreEqual(3, reader["price"]);

    Assert.IsFalse(reader.Read());
  }

  [Test]
  public void Find()
  {
    Product pb = new Product("Maso orzechowe", "mo", 3);
    Product jam = new Product("Dem truskawkowy", "dt", 2);

    gateway.Insert(pb);
    gateway.Insert(jam);

    Assert.IsNull(gateway.Find("Za warto sku"));

    Product foundPb = gateway.Find(pb.Sku);
    CheckThatProductsMatch(pb, foundPb);

    Product foundJam = gateway.Find(jam.Sku);
    CheckThatProductsMatch(jam, foundJam);
  }

  private static void CheckThatProductsMatch(Product pb, Product pb2)
  {
    Assert.AreEqual(pb.Name, pb2.Name);
    Assert.AreEqual(pb.Sku, pb2.Sku);
    Assert.AreEqual(pb.Price, pb2.Price);
  }
}
